#ifndef DDIALOGODIRECTORIOS_H
    #define DDIALOGODIRECTORIOS_H

    #include "DString.h"

    namespace DWL {
	    //! Clase que muestra un dialogo del sistema para seleccionar un directorio.
	    class DDialogoDirectorios {
	      public : /////////////// Miembros publicos

							    //! Constructor.
							    /*!	Constructor por defecto.
									    \fn		DDialogoDirectorios(void);
									    \return	No devuelve nada.
							    */
							    DDialogoDirectorios(void) { 
							    };

							    //! Constructor que muestra el dialogo.
							    /*!	Constructor que muestra el dialogo.
									    \fn			DWLDialogoDirectorios(const TCHAR *Titulo);
									    \param[in]	Titulo : Cadena de caracteres con el titulo del dialogo
									    \return		No devuelve nada.
							    */
							    DDialogoDirectorios(const TCHAR *Titulo) { 
								    MostrarDirectorios(Titulo); 
							    };

							    // DEPRECATED!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
							    //! Funcin que muestra el dialogo del sistema para seleccionar un directorio.
							    /*!	Esta funcin muestra el dialogo del sistema para seleccionar un directorio.
									    \fn			const TCHAR *MostrarDirectorios(const TCHAR *Titulo);
									    \param[in]	Titulo : Cadena de caracteres con el titulo del dialogo
									    \return		Devuelve la ruta del directorio seleccionado.
									    \todo       Esta funcin usa API de windows DEPRECATED, hay que re-emplazarla y mantener las deprecated solo para VC6
							    */
		    const TCHAR        *MostrarDirectorios(const TCHAR *Titulo);

							    //! Funcin que devuelve el directorio seleccionado
							    /*!	Esta funcion devuelve el directorio seleccionado
									    \fn			inline const TCHAR *Directorio(void);
									    \return		Devuelve una cadena de caracteres con el directorio seleccionado.
							    */
		    inline const TCHAR *Directorio(void) {
								    return _Directorio(); 
							    };

	      private : ////////////// Miembros privados

							    //! Directorio seleccionado
		    DString	           _Directorio;
	    };
    };

#endif